#include <calculaDistancia.h>

int main(int argc, char** argv)
{
  char *bandir=argv[1];
  char *nameA = argv[2];
  char *nameB = argv[3];
  char *ext = argv[4];
  int res = atoi(argv[5]);
  char *arq_name = argv[6];
	
  float_image_t *Alo=leImagemTipoEscala(bandir,"Lo",res,nameA,ext);
  float_image_t *Ahi=leImagemTipoEscala(bandir,"Hi",res,nameA,ext);
  float_image_t *Blo=leImagemTipoEscala(bandir,"Lo",res,nameB,ext);
  float_image_t *Bhi=leImagemTipoEscala(bandir,"Hi",res,nameB,ext);

  geraArqDistancias(Alo,Ahi,Blo,Bhi,arq_name,res);

  float_image_free(Alo);
  float_image_free(Ahi);
  float_image_free(Blo);
  float_image_free(Bhi);
  return 0;
}

void geraArqDistancias(float_image_t *Alo,float_image_t *Ahi,float_image_t *Blo,float_image_t *Bhi,char *nome,int escala)
{
  FILE *arq=fopen(nome,"w");
  if (arq == NULL) { fprintf(stderr, "** falhou abertura de '%s'\n", nome); assert(0); }
  float distlo=distLoRGB(Alo,Ahi,Blo,Bhi,FALSE);
  float disthi=distHiRGB(Alo,Ahi,Blo,Bhi,FALSE);
  fprintf(arq,"%d  %f  %f",escala,distlo,disthi);
  fclose(arq);
}
