#include <operacoes.h>
#include <calculoComparacao.h>

float_image_t *ex_read_image(FILE *rd, char *name)
  { bool_t close_it = FALSE;
    if (rd == NULL) { rd = open_read(name, TRUE); close_it = TRUE; }
    pnm_image_t *pim = pnm_image_fread(rd);
    float_image_t *fim = float_image_from_pnm_image(pim, NULL, NULL, FALSE);
    pnm_image_free(pim);
    if (close_it) { fclose(rd); }
    return fim;
  }

void ex_write_image(FILE *wr, char *name, float_image_t *img)
  { bool_t close_it = FALSE;
    if (wr == NULL) { wr = open_write(name, TRUE); close_it = TRUE; }
    int chns = img->sz[0];
    pnm_image_t *pim = float_image_to_pnm_image(img, chns, NULL, NULL, NULL, 255, FALSE);
    pnm_image_fwrite(wr, pim, FALSE);
    if (close_it) { fclose(wr); }
    pnm_image_free(pim);
  }

float_image_t *getImageOpenRGB(char *name)
{
   if (strlen(name)>=1)
   {
      FILE *arq;
      arq = fopen(name,"rw");
      if (arq == NULL) { fprintf(stderr, "** falhou abertura de '%s'\n", name); assert(0); }
      float_image_t *I = ex_read_image(arq, name);
      fclose(arq);
      if (I==NULL)
      {
         fprintf(stderr, "Não foi possível abrir o arquivo.\n");
      }
      return I;
   }
   return NULL;
}

//cria lista com todas as imagens em nível 5 de redução e ordenadas pela distLo
image_ref *criaListaOrdenadaRGB(char *bandir,int num,char *model_name,char *ext,int bgZero)
{
  image_ref *list = NULL;
   int i=0, resMax=5;
   float_image_t *Alo, *Ahi, *Blo, *Bhi;
   Alo=leImagemTipoEscala(bandir,"Lo",resMax,model_name,ext);

   Ahi=leImagemTipoEscala(bandir,"Hi",resMax,model_name,ext);
   for (i=0;i<num;i++)
   {
      char *bname=NULL;
      asprintf(&bname,"%05d",i);
      Blo=leImagemTipoEscala(bandir,"Lo",resMax,bname,ext);

      Bhi=leImagemTipoEscala(bandir,"Hi",resMax,bname,ext);
      if (strcmp(model_name, bname) != 0)
      {  float distlo = distLoRGB(Alo,Ahi,Blo,Bhi,bgZero);
         float disthi = distHiRGB(Alo,Ahi,Blo,Bhi,bgZero);
         fprintf(stderr, "Imagem  %s %02d  %8.6f  %8.6f inserida\n", bname, resMax, distlo,disthi);
         list=insertSortImage(list,distlo,disthi,bname,resMax);
      }
      float_image_free(Blo);
      float_image_free(Bhi);
      free(bname);
   }
   float_image_free(Alo);
   float_image_free(Ahi);
   return list;
}

void exibeMelhoresRGB(image_ref *list)
{
   image_ref *aux;
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   while (list!=NULL)
   {
      fprintf(stderr, "Nome: %s, DistLo: %4.4f, DistHi: %4.4f Res: %d\n",list->name,list->distLo,list->distHi,list->resolucao);
      aux=list;
      list=list->prox;
   }
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
}
