#include <principalRGB.h>

int main(int argc, char** argv)
{
   char *bandir = argv[1];     // Diretorio com banco de imagens reduzidas
   int num_imagens = atoi(argv[2]);
   int res_max = atoi(argv[3]);
   int fator = atoi(argv[4]);
   char *model_name = argv[5];
   char *ext = argv[6];
   int bgZero = atoi(argv[7]);
   int num_resultados = atoi(argv[8]);
   // indice do primeiro argv[] que eh nome de imagem:
   int iarg_imagens = 9;
   assert(argc == iarg_imagens + num_imagens);

   fprintf(stderr, "\n+++++++++++++++++++++++++++++++INICIO++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

   fprintf(stderr, "parametros:\n");
   fprintf(stderr, "diretório do banco = %s\n", bandir);
   fprintf(stderr, "número de imagens do banco = %d\n", num_imagens);
   fprintf(stderr, "escala de reducão máxima da imagem (0 = original) = %d\n", res_max);
   fprintf(stderr, "fator de redução das imagens = %d\n", fator);
   fprintf(stderr, "nome (número) da imagem modelo a procurar = %s\n", model_name);
   fprintf(stderr, "extensão das imagens = %s\n", ext);
   fprintf(stderr, "valor zero significa fundo = %d\n", bgZero);
   fprintf(stderr, "número de resultados desejados = %d\n", num_resultados);

   int distsPorNivel[res_max+1];
   int res;
   for (res = 0; res <= res_max; res++) { distsPorNivel[res] = 0; }

   selecaoImagemOrdenadasRGB(bandir,model_name,ext,res_max,fator,num_imagens,&(argv[iarg_imagens]),num_resultados,distsPorNivel,bgZero);

   
   fprintf(stderr, "\n++++++++++++++++++++++++++++++++++FIM++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
   float custoTotal = 0;
   for (res = res_max; res >= 0; res--)
   {
     int nd = distsPorNivel[res];
     float custo = nd*pow(0.25,res) * (res > 0 ? 2 : 1);
     fprintf(stderr, "R%02d: %5d %8.6f\n", res, nd,custo);
     custoTotal += custo;
   }
   fprintf(stderr, "\n");
   fprintf(stderr, "Custo total:    %8.6f\n",custoTotal);
   fprintf(stderr, "Custo relativo: %8.6f\n",custoTotal/num_imagens);
  return 0;
}
