#define _GNU_SOURCE
#include <math.h>
#include <reducaoRGB.h>

float_image_t *getImageLuminosidade(float_image_t *I)
{
  float_image_t *Y = float_image_new(1,I->sz[1],I->sz[2]);
  int i=0,j=0;
  for (i=0;i<I->sz[1];i++)
    for (j=0;j<I->sz[2];j++)
      {
	float L;
	if (I->sz[0] == 3)
	  { float R=float_image_get_sample(I,0,i,j);
	    float G=float_image_get_sample(I,1,i,j);
	    float B=float_image_get_sample(I,2,i,j);
	    L= R*0.3 + G*0.59 + B*0.11;
	  }
	else
	  {  L = float_image_get_sample(I,0,i,j); }
	float_image_set_sample(Y,0,i,j,L);
      }
  return Y;
}

//Variancia da Região retornada em vet e o maior valor em maior[0]
void getMediaVarianciaRegiaoRGB(float_image_t *Md,float_image_t *Vr,float md[],float vr[],int inil,int fiml,int inic,int fimc)
{
  int i,j,c;
  int np = (fiml-inil)*(fimc-inic);
  for (c=0; c < Md->sz[0]; c++)
    { 
      double somamd=0;
      for (i=inil;i<fiml;i++)
        for (j=inic;j<fimc;j++)
          {
	    float mdp=float_image_get_sample(Md,c,i,j);
	    somamd+=mdp;
          }
      md[c]=somamd/np;
 
      double somad2=0.0;
      double somavr=0.0;
        
      for (i=inil;i<fiml;i++)
        for (j=inic;j<fimc;j++)
          {
            float mdp=float_image_get_sample(Md,c,i,j);
            float vrp=float_image_get_sample(Vr,c,i,j);
            double d=mdp-md[c];
            double d2=d*d;
            somad2+=d2;
            somavr+=vrp; 
          }
      vr[c]=somad2/(np) + somavr/np;
    }
}

//escala os pixels da imagem para o domínio 0..1
float_image_t *getImageEscaladaRGB(float_image_t *I,float vari[])
{
  int i=0,j=0,c;   
  float valor=0;
      
  for (i=0;i<I->sz[1];i++)
    for (j=0;j<I->sz[2];j++)
      {         
	for (c=0; c < I->sz[0]; c++)
	  { 
	    valor=float_image_get_sample(I,c,i,j);         
	    valor=(valor*0.998047)/vari[c];
	    float_image_set_sample(I,c,i,j,(valor));
	  }
      }
  return I;
}

//cálcula a redução da imagem baseada em media e variância
void calculaMediaVarianciaRGB(float_image_t *Md,float_image_t *Vr,int fator)
{
  int i,j,x=0,y=0,c;
  float md[Md->sz[0]], vr[Md->sz[0]];
  for (i=0;i<Vr->sz[1];i+=fator)
    {
      for (j=0;j<Vr->sz[2];j+=fator)	
	{
	  getMediaVarianciaRegiaoRGB(Md,Vr,md,vr,i,i+fator,j,j+fator); 
	  for (c=0;c < Md->sz[0]; c++)
	    {    
	      float_image_set_sample(Md,c,y,x,md[c]);        
	      float_image_set_sample(Vr,c,y,x,vr[c]);
	    }
	  x++;		
	}
      y++;
      x=0;
    }
  Md->sz[1]=Md->sz[1]/fator;
  Md->sz[2]=Md->sz[2]/fator;
  Vr->sz[1]=Vr->sz[1]/fator;
  Vr->sz[2]=Vr->sz[2]/fator;
}


//identifica o menor intervalo de uma região
void getInterMenorRegiaoRGB(float_image_t *I,int inil,int fiml,int inic,int fimc,float menor[],float intervalo,bool_t ignorazero)
{
  int i,j,ch;
  for (ch = 0; ch < I->sz[0]; ch++) { menor[ch]=+INFINITY; }
  bool_t all_zero = TRUE;
  float val[I->sz[0]];
  for (i=inil;i<fiml;i++)
    for (j=inic;j<fimc;j++)
      { float_image_get_pixel(I, i,j, val);
	if ((!ignorazero) || (! pixelTodoZero(val, I->sz[0])))
	  { all_zero = FALSE;
	    for (ch = 0; ch < I->sz[0]; ch++) 
	      { if (menor[ch]>(val[ch]-intervalo)) 
		  { menor[ch]=val[ch]-intervalo; }
	      }
	  }
      }  
  if (all_zero) { for (ch = 0; ch < I->sz[0]; ch++) { menor[ch]=0; } }
}

//identifica o maior intervalo de uma região
void getInterMaiorRegiaoRGB(float_image_t *I,int inil,int fiml,int inic,int fimc,float maior[],float intervalo,bool_t ignorazero)
{
  int i,j,ch;
  for (ch = 0; ch < I->sz[0]; ch++) { maior[ch]=-INFINITY; }
  bool_t all_zero = TRUE;
  float val[3];
  for (i=inil;i<fiml;i++)
    for (j=inic;j<fimc;j++)
      { float_image_get_pixel(I, i,j, val);
	if ((!ignorazero) || (! pixelTodoZero(val, I->sz[0])))
	  { all_zero = FALSE;
	    for (ch = 0; ch < I->sz[0]; ch++) 
	      { if (maior[ch]<(val[ch]+intervalo))
		  { maior[ch]=val[ch]+intervalo; }
	      }
	  }
      }    
  if (all_zero) { for (ch = 0; ch < I->sz[0]; ch++) { maior[ch]=0; } }
}

bool_t pixelTodoZero(float val[], int nch)
{
  bool_t  todoZero = TRUE;
  int ch;
  for (ch = 0; ch < nch; ch++) { if (val[ch] != 0) { todoZero = FALSE; } }
  return todoZero;
}

//cálcula a redução da imagem baseada em intervalos menores
float_image_t *calculaIntervaloLoRGB(float_image_t *I,int k,float intervalo,bool_t ignorazero)
{
  int i=0,j=0,x=0,y=0,c;
  float menor[I->sz[0]];
  for (i=0;i<I->sz[1];i+=k)
    {
      for (j=0;j<I->sz[2];j+=k)	
	{		
	  getInterMenorRegiaoRGB(I,i,i+k,j,j+k,menor,intervalo,ignorazero); 
          for (c=0;c < I->sz[0]; c++)
	    { float_image_set_sample(I,c,y,x,menor[c]); }
	  x++;		
	}
      y++;
      x=0;
    }
  I->sz[1]=I->sz[1]/k;
  I->sz[2]=I->sz[2]/k;
  return I;
}

//cálcula a redução da imagem baseada em intervalos maiores
float_image_t *calculaIntervaloHiRGB(float_image_t *I,int k,float intervalo,bool_t ignorazero)
{
  int i=0,j=0,x=0,y=0,c;
  float maior[I->sz[0]];
  for (i=0;i<I->sz[1];i+=k)
    {
      for (j=0;j<I->sz[2];j+=k)	
	{		
	  getInterMaiorRegiaoRGB(I,i,i+k,j,j+k,maior,intervalo,ignorazero); 
	  for (c=0;c < I->sz[0]; c++)
	    { float_image_set_sample(I,c,y,x,maior[c]); }
	  x++;		
	}
      y++;
      x=0;
    }
  I->sz[1]=I->sz[1]/k;
  I->sz[2]=I->sz[2]/k;
  return I;
}
