#include <reduzbanco.h>
#include <sys/stat.h>

int main(int argc, char** argv)
{
  char *bandir = argv[1];
  char *nome = argv[2];
  int resMax = atoi(argv[3]);
  int fator = atoi(argv[4]);
  bool_t ignorazero = atoi(argv[5]);
  bool_t cinza = TRUE;

  fprintf(stderr, "\n+++++++++++++++++++++++++++++++INICIO++++++++++++++++++++++++++++++++++++++\n");
  fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

  fprintf(stderr, "parametros:\n");
  fprintf(stderr, "diretório do banco = %s\n", bandir);
  fprintf(stderr, "escala de reducão máxima da imagem (0 = original) = %d\n", resMax);
  fprintf(stderr, "fator de redução das imagens = %d\n", fator);
  fprintf(stderr, "nome (número) da imagem a reduzir = %s\n", nome);
  fprintf(stderr, "valor zero significa fundo = %d\n", ignorazero);
  fprintf(stderr, "grava versão cinza = %d\n", cinza);

  calculaPiramide(bandir,nome,resMax,fator,ignorazero,cinza);
  fprintf(stderr, "\n++++++++++++++++++++++++++++++++++FIM++++++++++++++++++++++++++++++++++++++\n");
  fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");

  //free(bandir);
  //free(nome);
  return 0;
}

void calculaPiramide(char *dir,char *nome,int resMax,int fatorReducao,bool_t ignorazero,bool_t cinza)
{
  char *filename=NULL;
  asprintf(&filename,"%s/%s/norm.ppm",dir,nome);
  float_image_t *I=getImageOpenRGB(filename);
  
  assert(I->sz[0] == 3);
  reduzFatorKRGB(I,nome,resMax,fatorReducao,dir,ignorazero);
  if (cinza) 
    { float_image_t *Y = getImageLuminosidade(I);
      reduzFatorKRGB(Y,nome,resMax,fatorReducao,dir,ignorazero);
      float_image_free(Y);
    }
  free(filename);
  float_image_free(I);
}

void escreveImagemTipoEscala(float_image_t *I,char *dir,char *nome,char *tipo,int res)
{
  char *filename=NULL;
  char *ext = (I->sz[0] == 1 ? "pgm" : "ppm");
  asprintf(&filename,"%s/%s/%s/R%02d.%s",dir,nome,tipo,res,ext);
  ex_write_image(NULL,filename,I);
  free(filename);
}

//realiza a redução (RGB ou cinza) em um fator determinado por parametro
void reduzFatorKRGB(float_image_t *I,char *nome,int resMax,int fatorReducao,char *dir,bool_t ignorazero)
{
  int res=0;

  char *kind[4] = { "Md", "Sd", "Lo", "Hi" };
  int ik;
  for (ik = 0; ik < 4; ik++ )
    {	char *outdirname=NULL;
      asprintf(&outdirname,"%s/%s/%s",dir,nome,kind[ik]);
      mkdir(outdirname, S_IRWXU+S_IXGRP+S_IXOTH);
      free(outdirname);
    }

  float_image_t *media=float_image_copy(I);
  float_image_t *desviopadrao=float_image_copy(I);
  float_image_t *intervaloLo=float_image_copy(I);
  float_image_t *intervaloHi=float_image_copy(I);
  while (1)
    {
      escreveImagemTipoEscala(media,dir,nome,"Md",res);
      escreveImagemTipoEscala(desviopadrao,dir,nome,"Sd",res);
      escreveImagemTipoEscala(intervaloLo,dir,nome,"Lo",res);
      escreveImagemTipoEscala(intervaloHi,dir,nome,"Hi",res);
      res++;
      if (res>resMax) break;
      calculaMediaVarianciaRGB(media,desviopadrao,fatorReducao);
      // !!! {ignorazero} deveria ser parametro do programa.
      intervaloLo=calculaIntervaloLoRGB(intervaloLo,fatorReducao,0.0,ignorazero);
      intervaloHi=calculaIntervaloHiRGB(intervaloHi,fatorReducao,0.0,ignorazero);
    }
  float_image_free(media);
  float_image_free(desviopadrao);
  float_image_free(intervaloLo);
  float_image_free(intervaloHi);
}

