#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hashlib.h"
#include "htmlib.h"

/* cria uma nova tag com um id */
NodePtr newIdTag(char *tagName, char *id, int closed){
  NodePtr p = newTag(tagName,closed);
  addAttrib(p,"id",id);
  return p;
}    
/* insere um ttulo (H1, H2, H3, etc.) numa pgina */
NodePtr insertHeader(HTMLPagePtr page,char *id, char *lev, char *text){
  NodePtr p = newTag(lev,true);
  appendChild(p,newText(text));
  insertElement(page,id,p);
  return p;
}    

int refCount = 0;  /* contador de referncias (usado nos hyperlinks) */

/* gera um id para um hyperlink */
char* newRefId(){
  char *ref = malloc(6);
  strcpy(ref,"#r");
  itoa(refCount++,&(ref[2]),10);
  return ref;
}    

/* insere uma referncia (hyperlink) numa pgina */
NodePtr insertRef(HTMLPagePtr page, char *id, char *url, char *text){
  printf("inserting ref %s %s\n",url,text);
  NodePtr p = newTag("a",true);
  addAttrib(p,"href",url);
  appendChild(p,newText(text));
  insertElement(page,id,p);
  return p;
}    

/* define o tipo de fonte */
NodePtr insertFont(HTMLPagePtr page, char *pageid, char *fontid, char *font){
  NodePtr p = newIdTag("FONT",fontid,true);
  addAttrib(p,"face",font);
  insertElement(page,pageid,p);
  return p;
}
    
/* monta um 'template' para a pgina a ser construda */
HTMLPagePtr makeTemplate(){
  HTMLPagePtr myPage = newPage("page");
  NodePtr myHead = newIdTag("HEAD","head",true);
  NodePtr myTitle = newIdTag("TITLE","title",true);
  NodePtr myBody = newIdTag("BODY","body",true);
  insertElement(myPage,"page",myHead);
  insertElement(myPage,"head",myTitle);
  insertElement(myPage,"page",myBody);   
  insertFont(myPage,"body","part1","arial");
  insertElement(myPage,"part1",newIdTag("SPAN","header",true));
  NodePtr tab1 = newIdTag("TABLE","tab1",true);
  addAttrib(tab1,"border","0");
  insertElement(myPage,"part1",tab1);
  insertElement(myPage,"tab1",newIdTag("TR","row1",true));
  NodePtr col1 = newIdTag("TD","col1",true);
  addAttrib(col1,"WIDTH","20%");
  addAttrib(col1,"VALIGN","top");
  addAttrib(col1,"BGCOLOR","EFEAEF");
  insertElement(myPage,"row1",col1);
  NodePtr col2 = newIdTag("TD","col2",true);
  addAttrib(col2,"WIDTH","80%");
  addAttrib(col2,"BGCOLOR","#FFFFF0");
  insertElement(myPage,"row1",col2);
  return myPage;
}                           

/* insere uma seco (tpico) na pgina */
void addSection(HTMLPagePtr page, char *sectTitle){
  char *ref = newRefId();
  NodePtr h1 = newTag("h2",true);
  NodePtr a1 = newTag("A",true);
  addAttrib(a1,"name",&(ref[1]));
  appendChild(h1,a1);
  appendChild(a1,newText(sectTitle));
  insertElement(page,"col2",h1);
  insertRef(page,"col1",ref,sectTitle);
  insertElement(page,"col1",newTag("BR",false));
}

/* insere um elemento do tipo texto na pgina */
void addText(HTMLPagePtr page, char *text){
  insertElement(page,"col2",newText(text));
}    
    
/* insere um ttulo na pgina */
void addTitle(HTMLPagePtr page, char *title){
  insertElement(page,"title",newText(title));
  insertHeader(page,"header","h1",title);
}   

/* insere um sub-ttulo na pgina */
void addSubTitle(HTMLPagePtr page, char *subtitle){
  insertHeader(page,"col2","h3",subtitle);
}   
    

/* faz uma cpia de uma linha de texto */
char *copyLine(char *line){
  char *p = malloc(strlen(line)+1);
  strcpy(p,line);
  return p;
}
    
int tMode = true;  /* indica se  texto normal ou 'pr-formatado'    */
int prCount = 0;   /* contador de textos pr-formatados              */
char *prId;        /* aponta para o id do ltimo texto pr-formatado */

/* gera uma nova id para um textp pr-formatado */
char *newPrId(){
  char *p = malloc(4);
  itoa(prCount++,p,10);
  prId=p;
  return p;
}

/* insere uma linha de texto pr-formatado na pgina */
void addPrText(HTMLPagePtr page, char *id, char* text){
  insertElement(page,id,newText(text));
}        

/* insere uma tag indicando 'texto pr-formatado' */
void addPreTag(HTMLPagePtr page){
  NodePtr p = newTag("PRE",true);
  addAttrib(p,"id",newPrId());
  insertElement(page,"col2",p);
}
    
/* insere uma tag de mudana de linha */
void addNewLine(HTMLPagePtr page){
  insertElement(page,"col2",newTag("P",true));
}

/* insere uma referncia a uma figura na pgina */
void addFigure(HTMLPagePtr page, char *url){
  NodePtr p = newTag("IMG",false);
  addAttrib(p,"src",url);
  insertElement(page,"col2",p);
}

/* insere um 'item de lista' */
void addItem(HTMLPagePtr page, char *text){
  NodePtr p = newTag("LI",true);
  appendChild(p,newText(text));
  insertElement(page,"col2",p);
}    

/* insere um hyperlink */
void addRef(HTMLPagePtr page, char *url){
  insertRef(page,"col2",url,url);
}    
        
/***********************************************************
    Processa uma linha de entrada. As linhas que se iniciam
    com '.' contm 'comandos' que podem ser:
    '.t' : ttulo da pgina (o restante da linha corresponde ao ttulo)
    '.p' : subttulo da pgina (o restante da linha conrresponde ao sub-ttulo)
    '.s' : nova seo (o restante da linha contm o cabealho da seo)
    '.c' : as linhas subsequentes, at o prximo 'comando' contm 
           cdigo-fonte (pr-formatado)
    '.n' : inicia uma nova linha (em HTML, 'pargrafo')
    '.f' : insere figura (o restante da linha contm o link p/ o arquivo 
           contendo a figura)
    '.i' : insere um 'item' na pgina (o restante da linha ...)
    '.h' : insere um 'hyperlink' na pgina (contido no restante da linha)
***********************************************************/
void processLine(char *line, HTMLPagePtr page){
  if(line[0] == '.') {
    tMode = true;
    switch(line[1]){
      case 't': /** titulo da pgina **/
                addTitle(page,copyLine(&(line[3])));     break;

      case 'p': /** subtitulo **/
                addSubTitle(page,copyLine(&(line[3])));  break;

      case 's': /** seo **/
                addSection(page,copyLine(&(line[3])));   break;

      case 'c': /** trecho pr-formatado (cdigo) **/
                addPreTag(page);          tMode = false; break;

      case 'n': /** nova linha **/
                addNewLine(page);                        break;

      case 'f': /** figura **/
                addFigure(page,copyLine(&(line[3])));    break;

      case 'i': /** item (bullet) **/
                addItem(page,copyLine(&(line[3])));      break;

      case 'h': /** hiperlink **/
                addRef(page,copyLine(&(line[3])));       break;

      default : /** comando desconhecido **/
                printf("comando desconhecido: %c\n",line[1]);
    }    
  } else if(tMode) addText(page,copyLine(line));      
         else addPrText(page,prId,copyLine(line)); 

}    

/* monta uma pgina a partir de um texto num arquivo */
HTMLPagePtr makePage(char *fileName){
    char line[256]; char *res;
    HTMLPagePtr page = makeTemplate();
    FILE* arq = fopen(fileName,"r");
    while( (res = fgets(line,255,arq))!= NULL) processLine(line,page);
    fclose(arq);
    return page;
}    

/* programa de testes */               
int main(int argc, char *argv[])
{ 
  HTMLPagePtr p = makePage("ativ10.txt");
  writePage(p,"ativ10.html");
  system("PAUSE");	
  return 0;
}

