#define true  1
#define false 0

/* apontador para um atributo */
typedef struct Attrib *AttribPtr;

/* descrio de um atributo */
typedef struct Attrib {
                        char *name;       /*  nome do atributo      */
                        char *value;      /*  valor do atributo     */
                        AttribPtr next;   /*  apontator p/ prximo  */
                      } Attrib;


/* apontador para um n da rvore */
typedef struct HTMLNode *NodePtr;

/* descrio de uma tag */
typedef struct { 
                 char *name;         /*   nome da tag                   */
                 int  closed;        /*   0 = 'aberta',  1 = 'fechada'  */
                 AttribPtr attrList; /*   lista de atributos            */
                 NodePtr childList;  /*   lista de 'filhos'             */
               } TagType;
                 

/* descreve o 'contedo' de um elemento da pgina */               
typedef union { 
                char *text;         /*  texto        */
                char *comment;      /*  comentario   */
                TagType tag;        /*  tag          */
              } HTMLContent;

/* tipos possveis de elementos de uma pgina */
typedef enum {TEXT, COMMENT, TAG } NodeType;

/* descreve um elemento da pgina */
typedef struct HTMLNode {
            		      NodeType type;         /*  tipo do n                */
                          HTMLContent content;   /*  contedo do n            */
                          NodePtr next;          /*  apontador para o prximo  */
                        } HTMLNode;


/*********************************************************************
    Descrio de uma pgina HTML
*********************************************************************/                               

/* apontador para um descritor de pgina */
typedef struct HTMLPage *HTMLPagePtr;
/* descritor de pgina */
typedef struct HTMLPage {
                          HashTable tab;        /*  tabela de hashing     */
                          NodePtr   nodeptr;    /*  tag principal (HTML)  */
                        } HTMLPage;

/*******************************************************************
*******************************************************************/

/* cria uma nova pgina (vazia) */
HTMLPagePtr newPage(char *);

/* insere um elemento a uma pgina como filho da tag que tem uma certa 'id' */
void insertElement(HTMLPagePtr, char *, NodePtr);

/* agrega um atributo a uma tag */
void addAttrib(NodePtr, char *, char*);

/* agrega um 'filho' a uma 'tag' */
void appendChild(NodePtr, NodePtr);

/* cria um 'elemento' do tipo 'tag HTML' */
NodePtr newTag(char *name, int closed);

/* cria um 'elemento'  do tipo comentrio */
NodePtr newComment(char *);

/* cria um 'elemento' do tipo texto */                          
NodePtr newText(char *);


/* escreve num arquivo o texto HTML correspondente a uma pgina */
void writePage(HTMLPagePtr, char *);
