#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hashlib.h"
#include "htmlib.h"


/* insere um ttulo (H1, H2, H3, etc.) numa pgina */
NodePtr insertHeader(HTMLPagePtr page,char *id, char *lev, char *text){
  NodePtr p = newTag(lev,true);
  appendChild(p,newText(text));
  insertElement(page,id,p);
  return p;
}    

/* insere uma referncia (hyperlink) numa pgina */
NodePtr insertRef(HTMLPagePtr page, char *id, char *url, char *text){
  NodePtr p = newTag("a",true);
  addAttrib(p,"href",url);
  appendChild(p,newText(text));
  insertElement(page,id,p);
  return p;
}    

/* define o tipo de fonte */
NodePtr insertFont(HTMLPagePtr page, char *pageid, char *fontid, char *font){
  NodePtr p = newTag("FONT",true);
  addAttrib(p,"face",font);
  addAttrib(p,"id",fontid);
  insertElement(page,pageid,p);
  return p;
}
    
/* monta uma pgina contendo o conjunto mnimo de elementos */
HTMLPagePtr makeTemplate(){
  HTMLPagePtr myPage = newPage("page");
  NodePtr myHead = newTag("HEAD",true);
  NodePtr myTitle = newTag("TITLE",true);
  NodePtr myBody = newTag("BODY",true);
  addAttrib(myHead,"id","head");
  addAttrib(myBody,"id","body");
  addAttrib(myTitle,"id","title");
  insertElement(myPage,"page",myHead);
  insertElement(myPage,"head",myTitle);
  insertElement(myPage,"page",myBody);   
  insertFont(myPage,"body","part1","arial");
  NodePtr header = newTag("SPAN",true);
  addAttrib(header,"id","header");
  insertElement(myPage,"part1",header);
  NodePtr tab1 = newTag("TABLE",true);
  addAttrib(tab1,"border","0");
  addAttrib(tab1,"id","tab1");
  insertElement(myPage,"part1",tab1);
  return myPage;
}                           

/* monta uma pgina exemplo */
HTMLPagePtr makePage1(){
  HTMLPagePtr myPage = makeTemplate();
  insertElement(myPage,"title",newText("Pgina exemplo"));
  insertHeader(myPage,"header","h1","MC 202 - turmas E e F");
  insertHeader(myPage,"header","h2","Segundo semestre de 2004");
  insertHeader(myPage,"header","h3","Atividade de Laboratrio no. 9");
  insertElement(myPage,"part1",newText("Este  apenas um exemplo de pgina HTML gerada por programa. "));
  insertElement(myPage,"part1",newTag("BR",false));
  insertElement(myPage,"part1",newText("Benvindo ao "));
  insertRef(myPage,"part1","http://www.ic.unicamp.br","IC-UNICAMP");
  return myPage;
}
               
int main(int argc, char *argv[])
{ 
  HTMLPagePtr p = makePage1();
  writePage(p,"pagina1.html");
  system("PAUSE");	
  return 0;
}

